/*
 * Decompiled with CFR 0.152.
 */
package com.android.login.data;

import com.Application;
import com.android.core.data.api.AndroidController;
import com.android.core.domain.AndroidService;
import com.android.core.domain.model.RequestData;
import com.android.login.domain.CompanyService;
import com.dto.android.CompanyDto;
import com.utility.DbConnection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/android/companies"})
public class CompanyController
extends AndroidController<CompanyDto> {
    DbConnection dbConnection;

    @Autowired
    protected CompanyController(Application app, AndroidService<CompanyDto> service, DbConnection dbConnection) {
        super(app, service);
        this.dbConnection = dbConnection;
    }

    @ApiIgnore
    @GetMapping
    @Nullable
    public final ResponseEntity<Map<String, Object>> getItems(HttpServletRequest request, @RequestParam(required=false, name="page", defaultValue="-1") int page, @RequestParam(required=false, name="itemsPerPage", defaultValue="-1") int itemsPerPage) {
        RequestData requestData = RequestData.builder().paramMap(RequestData.normalizeServletParams((HttpServletRequest)request)).build();
        ResponseEntity result = this.service.getItems(requestData, page, itemsPerPage);
        this.log.info("GET result: " + result);
        return result;
    }

    @GetMapping(value={"/all"})
    public ResponseEntity<Map<String, Object>> getAllCompanies() {
        return ((CompanyService)this.service).getAllCompanies();
    }
}

